<?php
    include 'dbconn.php';

    // Get product id from URL
    $id = isset($_GET['id']) ? (int) $_GET['id'] : 0;

    // Fetch product
    $sql    = "SELECT * FROM product WHERE id = $id LIMIT 1";
    $result = mysqli_query($mysqli, $sql);

    if ($row = mysqli_fetch_assoc($result)) {
        $pname        = $row['pname'];
        $price        = $row['upc']; // assuming price stored here
        $old_price    = isset($row['old_price']) ? $row['old_price'] : '';
        $availability = $row['availability'] == 'yes' ? 'In Stock' : 'Out of Stock';

        $catid    = $row['catid'];
        $subcatid = $row['subcatid'];

        $images = [
            $row['pimage'],
            $row['pimage2'],
            $row['pimage3'],
            $row['pimage4'],
            $row['pimage5'],
        ];

        // Fetch category name
        $cat_sql       = "SELECT category FROM category WHERE id = $catid LIMIT 1";
        $cat_result    = mysqli_query($mysqli, $cat_sql);
        $category_name = ($cat_row = mysqli_fetch_assoc($cat_result)) ? $cat_row['category'] : '';

        // Fetch subcategory name
        $subcat_sql       = "SELECT subcategory FROM subcategory WHERE id = $subcatid LIMIT 1";
        $subcat_result    = mysqli_query($mysqli, $subcat_sql);
        $subcategory_name = ($subcat_row = mysqli_fetch_assoc($subcat_result)) ? $subcat_row['subcategory'] : '';
    }
?>


<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="robots" content="index, follow" />
     <title>Craftsy Angel – Where Gifting Meets Creativity</title>
    <meta name="description" content="Mioca - Handmade Goods eCommerce HTML Template" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">


    <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
    <link rel="stylesheet" href="assets/css/style.min.css">

    <style>
  .color-palette {
    display: flex;
    gap: 6px;
    flex-wrap: wrap;
    align-items: center;
}

.color-circle {
    width: 22px;
    height: 22px;
    border-radius: 50%;
    border: 1px solid #ccc;
    box-shadow: 0 0 2px rgba(0,0,0,0.3);
    flex-shrink: 0;
}
    .color-circle:hover {
        transform: scale(1.1);
        transition: transform 0.2s ease-in-out;
    }
</style>
</head>

<body>


    <header>
        <div class="header-main sticky-nav ">
            <div class="container position-relative">
                <div class="row">
                    <div class="col-auto align-self-center">
                        <div class="header-logo">
                            <a href="index.html"><img src="assets/images/logo/logo.png" alt="Site Logo" /></a>
                        </div>
                    </div>
                     <div class="col align-self-center d-none d-lg-block">
                            <div class="main-menu">
                                <ul>
                                    <li class="dropdown"><a href="index.php">Home</a>
                                    </li>
                                    <li><a href="about.html">About</a></li>
                                    <li><a href="products.php">Products</a></li>
                                    <li class="dropdown position-static"><a href="#">Shop <i
                                                class="fa fa-angle-down"></i></a>
                                         <ul class="sub-menu">
                                            <li><a href="bags.php">Bags</a></li>
                                            <li><a href="cake_topper.php">Cake Topper</a></li>
                                            <li><a href="hair_clip.php">Hair Clips</a></li>
                                            <li><a href="home_decor.php">Home Decor</a></li>
                                            <li><a href="keychain.php">Keychain</a></li>
                                            <li><a href="nursary_decor.php">Nursary Decor</a></li>
                                            <li><a href="plant_hanging.php">Plant Hanging</a></li>
                                            <li><a href="rainbow.php">Rainbow</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="contact.html">Contact</a></li>
                                </ul>
                            </div>
                        </div>
                     <div class="col col-lg-auto align-self-center pl-0">
                            <div class="header-actions">
                                <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
                                    <i class="pe-7s-search"></i>
                                </a>
                                <div class="header-bottom-set dropdown">
                                    <button class="dropdown-toggle header-action-btn" data-bs-toggle="dropdown"><i
                                            class="pe-7s-users"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a class="dropdown-item" href="my-account.php">My account</a></li>
                                        <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
                                        <li><a class="dropdown-item" href="login.html">Sign in</a></li>
                                    </ul>
                                </div>
                                <a href="wishlist.php" class="header-action-btn">
                                    <i class="pe-7s-like"></i>
                                    <span class="header-action-num">01</span>
                                </a>
                                <a href="my_cart.php"
                                    class="header-action-btn ">
                                    <i class="pe-7s-shopbag"></i>
                                    <span class="header-action-num">01</span>
                                    </a>

                            </div>
                            </div>
                </div>
            </div>
        </div>
    </header>
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <h2 class="breadcrumb-title">Single Product</h2>
                    <ul class="breadcrumb-list">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item active">Product</li>
                    </ul>
                    </div>
            </div>
        </div>
    </div>
    <div class="product-details-area pt-100px pb-100px">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-6 col-sm-12 col-xs-12 mb-lm-30px mb-md-30px mb-sm-30px">
                                    <div class="swiper-container zoom-top">
                    <div class="swiper-wrapper">
                        <?php foreach ($images as $img): ?>
<?php if (! empty($img)): ?>
                                <div class="swiper-slide zoom-image-hover">
                                    <img class="img-responsive m-auto" src="Admin/uploads/product/<?php echo $img; ?>" alt="">
                                </div>
                            <?php endif; ?>
<?php endforeach; ?>
                    </div>
                </div>

                <div class="swiper-container mt-20px zoom-thumbs ">
                    <div class="swiper-wrapper">
                        <?php foreach ($images as $img): ?>
<?php if (! empty($img)): ?>
                                <div class="swiper-slide">
                                    <img class="img-responsive m-auto" src="Admin/uploads/product/<?php echo $img; ?>" alt="">
                                </div>
                            <?php endif; ?>
<?php endforeach; ?>
                    </div>
                </div>
                                </div>
                <div class="col-lg-6 col-sm-12 col-xs-12" data-aos="fade-up" data-aos-delay="200">
                    <div class="product-details-content quickview-content ml-25px">
                        <h2><?php echo $pname; ?></h2>
                       <div class="pricing-meta">
                            <ul class="d-flex">
                                <li class="new-price">$<?php echo $price; ?></li>
                                <?php if (! empty($old_price)): ?>
                                    <li class="old-price"><del>$<?php echo $old_price; ?></del></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                         <div class="pro-details-rating-wrap">
                            <div class="rating-product">
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                                <i class="fa fa-star"></i>
                            </div>
                            <span class="read-review"><a class="reviews" href="#">( 2 Review )</a></span>
                        </div>
                        <div class="stock mt-30px">
                            <span class="avallabillty">Availability:
                                <span class="<?php echo $availability == 'In Stock' ? 'in-stock' : 'out-of-stock'; ?>">
                                    <i class="fa fa-check"></i><?php echo $availability; ?>
                                </span>
                            </span>
                        </div>

                        <p class="mt-30px mb-0"><?php echo $row['sdesc']; ?></p>

                         <div class="product-anotherinfo-wrapper text-start">
                            <ul>

                            <li class="color-list">

                               <div class="color-palette">
                            Colors :
                            <?php
                                if (! empty($row['colors'])) {
                                    $colorArray = explode(',', $row['colors']);
                                    foreach ($colorArray as $color) {
                                        $color = trim($color);
                                        echo '<div class="color-circle"
                                                data-color="' . htmlspecialchars($color) . '"
                                                style="background-color:' . htmlspecialchars($color) . '"
                                                title="' . htmlspecialchars($color) . '"></div>';
                                    }
                                } else {
                                    echo "No colors available";
                                }
                            ?>
                        </div>

                            </li>


                            <li>
                                <span>Time To Deliver : </span>
                                <?php echo htmlspecialchars($row['delivery_time']); ?>
                            </li>
                                </ul>
                        </div>
                        <div class="pro-details-quality">
                            <div class="cart-plus-minus">
                                <div class="dec qtybutton">-</div>
                                <input class="cart-plus-minus-box" type="text" id="qtybox" value="1" />
                                <div class="inc qtybutton">+</div>
                            </div>
                            <form action="add_to_cart.php" method="post" id="addToCartForm">
                                <input type="hidden" name="product_id" value="<?php echo $id; ?>">
                                <input type="hidden" name="quantity" id="quantityInput" value="1">
                                <input type="hidden" name="color" id="colorInput" value="">

                                <div class="pro-details-cart">
                                    <button type="submit" class="add-cart">Add To Cart</button>
                                </div>
                            </form>

                            <div class="pro-details-compare-wishlist pro-details-wishlist">
                                <a href="add_to_wishlist.php?product_id=<?php echo $id; ?>"><i class="pe-7s-like"></i></a>
                            </div>
                        </div>

                       <div class="pro-details-categories-info pro-details-same-style d-flex">
                            <span>Categories: </span>
                            <ul class="d-flex">
                                <li>
                                    <a href="#">
                                        <?php
                                            echo htmlspecialchars($category_name);
                                            if (! empty($subcategory_name)) {
                                                echo ' (' . htmlspecialchars($subcategory_name) . ')';
                                            }
                                        ?>
                                    </a>
                                </li>
                            </ul>
                        </div>


                        <div class="pro-details-social-info pro-details-same-style d-flex">
                            <span>Share: </span>
                            <ul class="d-flex">

                                <li>
                                    <a href="https://www.instagram.com/craftsyangel/"><i class="fa fa-instagram"></i></a>
                                </li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="description-review-area pb-100px" data-aos="fade-up" data-aos-delay="200">
        <div class="container">
            <div class="description-review-wrapper">
                <div class="description-review-topbar nav">

                    <a class="active" data-bs-toggle="tab" href="#des-details1">Description</a>
                    <a data-bs-toggle="tab" href="#des-details3">Reviews (02)</a>
                </div>
                <div class="tab-content description-review-bottom">
                    <div id="des-details2" class="tab-pane">

                    </div>
                    <div id="des-details1" class="tab-pane active">
                        <div class="product-description-wrapper">
                            <p class="mt-30px mb-0"><?php echo $row['ldesc']; ?></p>
                        </div>
                    </div>
                    <div id="des-details3" class="tab-pane">
                        <div class="row">
                            <div class="col-lg-7">
                                <div class="review-wrapper">
                                    <div class="single-review">
                                        <div class="review-img">
                                            <img src="assets/images/review-image/1.png" alt="" />
                                        </div>
                                        <div class="review-content">
                                            <div class="review-top-wrap">
                                                <div class="review-left">
                                                    <div class="review-name">
                                                        <h4>White Lewis</h4>
                                                    </div>
                                                    <div class="rating-product">
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="review-bottom">
                                                <p>
                                                    Vestibulum ante ipsum primis aucibus orci luctustrices posuere
                                                    cubilia Curae Suspendisse viverra ed viverra. Mauris ullarper
                                                    euismod vehicula. Phasellus quam nisi, congue id nulla.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="single-review child-review">
                                        <div class="review-img">
                                            <img src="assets/images/review-image/2.png" alt="" />
                                        </div>
                                        <div class="review-content">
                                            <div class="review-top-wrap">
                                                <div class="review-left">
                                                    <div class="review-name">
                                                        <h4>White Lewis</h4>
                                                    </div>
                                                    <div class="rating-product">
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                        <i class="fa fa-star"></i>
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="review-bottom">
                                                <p>Vestibulum ante ipsum primis aucibus orci luctustrices posuere
                                                    cubilia Curae Sus pen disse viverra ed viverra. Mauris ullarper
                                                    euismod vehicula.</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-5">
                                <div class="ratting-form-wrapper pl-50">
                                    <h3>Add a Review</h3>
                                    <div class="ratting-form">
                                        <form action="#">
                                            <div class="star-box">
                                                <span>Your rating:</span>
                                                <div class="rating-product">
                                                    <i class="fa fa-star"></i>
                                                    <i class="fa fa-star"></i>
                                                    <i class="fa fa-star"></i>
                                                    <i class="fa fa-star"></i>
                                                    <i class="fa fa-star"></i>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="rating-form-style">
                                                        <input placeholder="Name" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="rating-form-style">
                                                        <input placeholder="Email" type="email" />
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="rating-form-style form-submit">
                                                        <textarea name="Your Review" placeholder="Message"></textarea>
                                                        <button class="btn btn-primary btn-hover-color-primary "
                                                            type="submit" value="Submit">Submit</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="related-product-area">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="section-title text-center line-height-1">
                    <h2 class="title">Related Products</h2>
                    <p class="sub-title">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
                        incididunt ut labore et dolore magna aliqua.
                    </p>
                </div>
            </div>
        </div>
        <div class="new-product-slider swiper-container slider-nav-style-1 pb-100px">
            <div class="new-product-wrapper swiper-wrapper">

                <?php
                    // Fetch related products (prefer subcategory, fallback to category)
                    $related_sql = "SELECT * FROM product
                                WHERE id != $id
                                AND (
                                    (subcatid = $subcatid AND $subcatid > 0)
                                    OR (catid = $catid)
                                )
                                LIMIT 6";
                    $related_result = mysqli_query($mysqli, $related_sql);

                    while ($rel = mysqli_fetch_assoc($related_result)) {
                        $rel_image_main  = ! empty($rel['pimage']) ? "Admin/uploads/product/" . $rel['pimage'] : "assets/images/no-image.jpg";
                        $rel_image_hover = ! empty($rel['pimage2']) ? "Admin/uploads/product/" . $rel['pimage2'] : $rel_image_main;
                        $rel_price       = $rel['upc']; // Assuming price stored here
                    ?>
                    <div class="new-product-item swiper-slide">
                        <div class="product">
                            <div class="thumb">
                                <a href="single-product.php?id=<?php echo $rel['id']; ?>" class="image">
                                    <img src="<?php echo htmlspecialchars($rel_image_main); ?>" alt="Product" />
                                    <img class="hover-image" src="<?php echo htmlspecialchars($rel_image_hover); ?>" alt="Product" />
                                </a>

                                <div class="actions">
                                    <a href="wishlist.php?id=<?php echo $rel['id']; ?>" class="action wishlist" title="Wishlist"><i
                                            class="pe-7s-like"></i></a>

                                </div>
                            </div>
                            <div class="content">
                                <span class="ratings">
                                    <span class="rating-wrap">
                                        <span class="star" style="width: 100%"></span>
                                    </span>
                                    <span class="rating-num">( 5 Review )</span>
                                </span>
                                <h5 class="title">
                                    <a href="single-product.php?id=<?php echo $rel['id']; ?>">
                                        <?php echo htmlspecialchars($rel['pname']); ?>
                                    </a>
                                </h5>
                                <span class="price">
                                    <span class="new">₹<?php echo number_format($rel_price, 2); ?></span>
                                    <?php if (! empty($rel['old_price'])) {?>
                                        <span class="old">₹<?php echo number_format($rel['old_price'], 2); ?></span>
                                    <?php }?>
                                </span>
                            </div>
                           <a href="single-product.php?id='.$row['id'].'" title="Add To Cart" class="add-to-cart">Add To Cart</a>
                        </div>
                    </div>
                <?php
                    }
                ?>

            </div>
            <div class="swiper-buttons">
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
    </div>
</div>
<div class="newsletter-area ">
        <div class="container line-shape-bottom">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="newsletter-content mb-lm-30px">
                        <i class="pe-7s-mail-open-file"></i>
                        <div class="newsletter-text">
                            <h3 class="title">Newsletter & Get Updates</h3>
                            <p>Sign up for our newsletter to get update from us</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="news-letter-form">
                        <div id="mc_embed_signup" class="subscribe-form">
                            <form id="mc-embedded-subscribe-form" class="validate" novalidate="" target="_blank"
                                name="mc-embedded-subscribe-form" method="post"
                                action="http://devitems.us11.list-manage.com/subscribe/post?u=6bbb9b6f5827bd842d9640c82&amp;id=05d85f18ef">
                                <div id="mc_embed_signup_scroll" class="mc-form">
                                    <input class="email" type="email" required=""
                                        placeholder="Enter Your Mail Here......." name="EMAIL" value="">
                                    <div class="mc-news d-none" aria-hidden="true">
                                        <input type="text" value="" tabindex="-1"
                                            name="b_6bbb9b6f5827bd842d9640c82_05d85f18ef">
                                    </div>
                                    <div class="clear">
                                        <button id="mc-embedded-subscribe" class="button" type="submit" name="subscribe"
                                            value=""> Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

     <!-- Footer Area Start -->
        <div class="footer-area">
            <div class="footer-container">
                <div class="footer-top">
                    <div class="container">
                        <div class="row">
                            <!-- Start single blog -->
                            <div class="col-md-8 col-sm-6 col-lg-4 mb-md-30px mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Craftsy Angel</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            Mcrame, crafted by the skilled hands <br>of the artisans at Craftsy Angel,<br> is a true testament to the beauty of hand-made creations.
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Account</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" href="about.html">About us</a></li>
                                                <li class="li"><a class="single-link" href="contact.html">Contact Us</a></li>
                                                <li class="li"><a class="single-link" href="return_policy.php">Return Policy</a></li>
                                                <li class="li"><a class="single-link" href="refund_policy.php">Refund Policy</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-sm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Shop </h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" href="bags.php">Bags</a></li>
                                                <li class="li"><a class="single-link" href="cake_topper.php">Cake Topper</a></li>
                                                <li class="li"><a class="single-link" href="hair_clip.php">Hair Clips</a></li>
                                                <li class="li"><a class="single-link" href="home_decor.php">Home Decor</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-4 col-lg-4 col-md-6 col-sm-6 pl-120px line-shape">
                                <div class="single-wedge ">

                                    <h4 class="footer-herading">Contact Us</h4>
                                    <div class="footer-links">

                                       <p><i class="pe-7s-phone"></i><span><a href="tel:+91 931 380 4653"> +91 931 380 4653</a></p>
                                        <p><i class="pe-7s-mail"></i><span><a href="mailto:info@craftsyangel.com"> info@craftsyangel.com</a></span></p>
                                        <p><i class="pe-7s-map-marker"></i> <span>Craftsy Angel,
                                                <br>
                                                Plot 504/1&2 GIDC Estate, Makarpura, Vadodara-390010, Gujarat, INDIA.</span> </p>

                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                        </div>
                    </div>
                </div>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="line-shape-top">
                            <div class="row flex-md-row-reverse align-items-center">
                                <div class="col-md-6 text-center text-md-end">

                                </div>
                                <div class="col-md-6 text-center text-md-start">
                                    <p class="copy-text"> © 2025 <strong>Craftsy Angel</strong> | All Rights Received.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer Area End -->
    <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->
    <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugins/plugins.min.js"></script>

    <script src="assets/js/main.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Handle color selection
            const colorCircles = document.querySelectorAll(".color-circle");
            const colorInput = document.getElementById("colorInput");

            colorCircles.forEach(circle => {
                circle.addEventListener("click", function() {
                    colorCircles.forEach(c => c.style.outline = "none");
                    this.style.outline = "2px solid #000"; // show selection
                    colorInput.value = this.dataset.color; // set hidden input
                });
            });

            // Handle quantity sync
            const qtyBox = document.getElementById("qtybox");
            const quantityInput = document.getElementById("quantityInput");
            const qtyButtons = document.querySelectorAll(".qtybutton");

            // Function to update the hidden input
            const updateHiddenQuantity = () => {
                let currentVal = parseInt(qtyBox.value, 10);
                if (currentVal < 1 || isNaN(currentVal)) {
                    qtyBox.value = 1;
                }
                quantityInput.value = qtyBox.value;
            };

            // Listen for changes on the input box itself
            qtyBox.addEventListener("change", updateHiddenQuantity);
            qtyBox.addEventListener("keyup", updateHiddenQuantity);

            // Listen for clicks on the increment/decrement buttons
            qtyButtons.forEach(button => {
                button.addEventListener("click", function() {
                    let currentVal = parseInt(qtyBox.value, 10);
                    if (this.classList.contains("inc")) {
                        qtyBox.value = currentVal + 1;
                    } else if (this.classList.contains("dec")) {
                        if (currentVal > 1) { // Prevent quantity from going below 1
                            qtyBox.value = currentVal - 1;
                        }
                    }
                    updateHiddenQuantity(); // Update the hidden input after button click
                });
            });

            // Set the initial hidden input value on page load
            updateHiddenQuantity();
        });
    </script>
</body>

</html>